/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.transform;

import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.Angle2D;
import math.geom2d.Point2D;
import math.geom2d.Shape2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearRing2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.conic.CircleArc2D;
import math.geom2d.domain.BoundaryPolyCurve2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.transform.Bijection2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircleInversion2D
implements Bijection2D {
    protected Point2D center;
    protected double radius;

    public static CircleInversion2D create(Point2D center, double radius) {
        return new CircleInversion2D(center, radius);
    }

    public static CircleInversion2D create(Circle2D circle) {
        return new CircleInversion2D(circle);
    }

    public CircleInversion2D() {
        this.center = new Point2D();
        this.radius = 1.0;
    }

    public CircleInversion2D(Circle2D circle) {
        this.center = circle.getCenter().clone();
        this.radius = circle.getRadius();
    }

    public CircleInversion2D(Point2D center, double radius) {
        this.center = center.clone();
        this.radius = radius;
    }

    public CircleInversion2D(double xc, double yc, double radius) {
        this.center = new Point2D(xc, yc);
        this.radius = radius;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    @Deprecated
    public void setCircle(double xc, double yc, double r) {
        this.center = new Point2D(xc, yc);
        this.radius = r;
    }

    @Deprecated
    public void setCircle(Circle2D circle) {
        this.center = circle.getCenter().clone();
        this.radius = circle.getRadius();
    }

    @Deprecated
    public Shape2D transformShape(Shape2D shape) {
        if (shape instanceof Point2D) {
            return this.transform((Point2D)shape);
        }
        if (shape instanceof CirculinearCurve2D) {
            CirculinearCurve2D curve = (CirculinearCurve2D)shape;
            return curve.transform(this);
        }
        if (shape instanceof Polygon2D) {
            Collection<? extends LinearRing2D> rings = ((Polygon2D)shape).getRings();
            ArrayList<CirculinearRing2D> curves = new ArrayList<CirculinearRing2D>(rings.size());
            for (LinearRing2D linearRing2D : rings) {
                curves.add(linearRing2D.transform(this));
            }
            return new ContourArray2D(curves);
        }
        return null;
    }

    @Deprecated
    public BoundaryPolyCurve2D<CircleArc2D> transformRing(LinearRing2D ring) {
        Collection<LineSegment2D> edges = ring.getEdges();
        ArrayList<CircleArc2D> arcs = new ArrayList<CircleArc2D>();
        for (LineSegment2D edge : edges) {
            arcs.add((CircleArc2D)this.transformShape(edge));
        }
        return new BoundaryPolyCurve2D<CircleArc2D>((Collection<CircleArc2D>)arcs);
    }

    @Override
    public CircleInversion2D invert() {
        return this;
    }

    @Override
    public Point2D transform(Point2D pt) {
        double r = this.radius;
        double d = r * r / Point2D.getDistance(pt, this.center);
        double theta = Angle2D.getHorizontalAngle(this.center, pt);
        return Point2D.createPolar(this.center, d, theta);
    }

    @Override
    public Point2D[] transform(Point2D[] src, Point2D[] dst) {
        int i;
        if (dst == null) {
            dst = new Point2D[src.length];
        }
        if (dst[0] == null) {
            i = 0;
            while (i < dst.length) {
                dst[i] = new Point2D();
                ++i;
            }
        }
        double xc = this.center.getX();
        double yc = this.center.getY();
        double r = this.radius;
        i = 0;
        while (i < src.length) {
            double d = Point2D.getDistance(src[i].getX(), src[i].getY(), xc, yc);
            d = r * r / d;
            double theta = Math.atan2(src[i].getY() - yc, src[i].getX() - xc);
            dst[i] = new Point2D(d * Math.cos(theta), d * Math.sin(theta));
            ++i;
        }
        return dst;
    }
}

